/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.client.gui.components.AbstractPreciseWidget;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import dev.lucaargolo.charta.utils.TickableWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCardWidget
extends AbstractPreciseWidget
implements TickableWidget,
HoverableRenderable {
    @Nullable
    private final HoverableRenderable parent;
    @Nullable
    private final class_2960 cardId;
    @Nullable
    private final String cardTranslatableKey;
    private final int cardColor;
    private float lastInset = 0.0f;
    private float inset = 0.0f;
    private float lastFov = 30.0f;
    private float fov = 30.0f;
    private float lastXRot = 0.0f;
    private float xRot = 0.0f;
    private float lastYRot = 0.0f;
    private float yRot = 0.0f;

    public AbstractCardWidget(@Nullable HoverableRenderable parent, @Nullable class_2960 cardId, @Nullable String cardTranslatableKey, int cardColor, float x, float y, float scale) {
        super(x, y, 37.5f * scale, 52.5f * scale, (class_2561)class_2561.method_43473());
        this.parent = parent;
        this.cardId = cardId;
        this.cardTranslatableKey = cardTranslatableKey;
        this.cardColor = cardColor;
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22762 && this.getCardTranslatableKey() != null) {
            this.scheduleTooltip((class_2561)class_2561.method_43471((String)this.getCardTranslatableKey()).method_54663(this.getCardColor()));
        }
        float inset = class_3532.method_16439((float)partialTick, (float)this.lastInset, (float)this.inset);
        float fov = class_3532.method_16439((float)partialTick, (float)this.lastFov, (float)this.fov);
        float xRot = class_3532.method_16439((float)partialTick, (float)this.lastXRot, (float)this.xRot);
        float yRot = class_3532.method_16439((float)partialTick, (float)this.lastYRot, (float)this.yRot);
        ChartaClient.CARD_INSET.accept(Float.valueOf(inset));
        ChartaClient.CARD_FOV.accept(Float.valueOf(fov));
        ChartaClient.CARD_X_ROT.accept(Float.valueOf(xRot));
        ChartaClient.CARD_Y_ROT.accept(Float.valueOf(yRot));
        float xOffset = (this.getPreciseWidth() * 1.333333f - this.getPreciseWidth()) / 2.0f;
        float yOffset = (this.getPreciseHeight() * 1.333333f - this.getPreciseHeight()) / 2.0f;
        ChartaGuiGraphics.blitCard(guiGraphics, this.getCardTexture(this.cardId, false), this.getPreciseX() - xOffset, this.getPreciseY() - yOffset, this.getPreciseWidth() + xOffset * 2.0f, this.getPreciseHeight() + yOffset * 2.0f);
        ChartaClient.getGlowRenderTarget().method_1235(false);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ChartaGuiGraphics.blitCard(guiGraphics, this.getCardTexture(this.cardId, false), this.getPreciseX() - xOffset, this.getPreciseY() - yOffset, this.getPreciseWidth() + xOffset * 2.0f, this.getPreciseHeight() + yOffset * 2.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ChartaGuiGraphics.blitCardGlow(guiGraphics, this.getCardTexture(this.cardId, true), this.getPreciseX() - xOffset, this.getPreciseY() - yOffset, this.getPreciseWidth() + xOffset * 2.0f, this.getPreciseHeight() + yOffset * 2.0f);
        class_310.method_1551().method_1522().method_1235(false);
        this.lastInset = inset;
        this.lastFov = fov;
        this.lastXRot = xRot;
        this.lastYRot = yRot;
    }

    @Override
    public void tick(int mouseX, int mouseY) {
        float xDif = (this.getPreciseX() + this.getPreciseWidth() - (float)mouseX - this.getPreciseWidth() / 2.0f) / (this.getPreciseWidth() / 2.0f);
        float yDif = (this.getPreciseY() + this.getPreciseHeight() - (float)mouseY - this.getPreciseHeight() / 2.0f) / (this.getPreciseHeight() / 2.0f);
        if (this.method_49606()) {
            this.inset = -30.0f;
            this.fov = 30.0f;
            this.xRot = yDif * 25.0f;
            this.yRot = xDif * -25.0f;
        } else {
            this.inset = 0.0f;
            this.fov = 30.0f;
            this.xRot = 0.0f;
            this.yRot = 0.0f;
        }
    }

    @Override
    public void scheduleTooltip(class_2561 component) {
        if (this.parent != null) {
            this.parent.scheduleTooltip(component);
        }
    }

    @Override
    public boolean method_49606() {
        return this.parent != null && this.parent.getHoverable() == this;
    }

    @NotNull
    public abstract class_2960 getCardTexture(@Nullable class_2960 var1, boolean var2);

    @Nullable
    public String getCardTranslatableKey() {
        return this.cardTranslatableKey;
    }

    public int getCardColor() {
        return this.cardColor;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }
}

